#include "main.h"

vertex normalize( vertex v ){
  vertex nv;
  float length;

  length = sqrtf( v.x*v.x+v.y*v.y+v.z*v.z );
  if( length != 0){
    nv.x = v.x/length;
    nv.y = v.y/length;
    nv.z = v.z/length;
  } /*else
    
    printf("WARNING: division by zero in normalize\n ");
*/
  return nv;
}

vertex calc_normals( triangle tri ){
  vertex surf_normal;
  vertex v1, v2;

  v1.x = tri.vertices[1].x - tri.vertices[0].x;
  v1.y = tri.vertices[1].y - tri.vertices[0].y;
  v1.z = tri.vertices[1].z - tri.vertices[0].z;

  v2.x = tri.vertices[2].x - tri.vertices[0].x;
  v2.y = tri.vertices[2].y - tri.vertices[0].y;
  v2.z = tri.vertices[2].z - tri.vertices[0].z;

  surf_normal.x = v1.y*v2.z - v1.z*v2.y;
  surf_normal.y = v1.z*v2.x - v1.x*v2.z;
  surf_normal.z = v1.x*v2.y - v1.y*v2.x;

  surf_normal = normalize( surf_normal );

  return surf_normal;
/*
 * C = A x B
    Cx = AyBz - AzBy
    Cy = AzBx - AxBz
    Cz = AxBy - AyBx
*/


}

